<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class StatutoryMaster extends Model
{
    protected $table = 'statutory_master';

    protected $fillable = [
        'statutory_code',
        'state_id',
        'act_name',
        'form_no',
        'description',
        'classifications',
        'periodicity',
        'due_date_raw',
        'jurisdiction_type',
        'submission_authority_id',
        'remarks',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

     // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;


    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function submission_authority_master()
    {
        return $this->belongsTo(SubmissionAuthorityMaster::class, 'submission_authority_id');
    }

    public function statutory_sections()
    {
        return $this->hasMany(StatutorySections::class, 'statutory_id', 'id');
    }
}
