<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\CityMaster;
use App\Models\StateMaster;

class Office extends Model
{
    protected $table = 'office';

    protected $fillable = [
        'is_head_office',
        'office_code',
        'name',
        'contact_person',
        'email',
        'phone',
        'mobile',
        'address',
        'city_id',
        'state_id',
        'pincode',
        'pincode',
        'status',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

    // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    // Relationships
    public function city_master()
    {
        return $this->belongsTo(CityMaster::class, 'city_id');
    }

    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function users()
    {
        return $this->hasMany(User::class, 'office_id', 'id');
    }
}
