<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormInstanceValue extends Model
{
    protected $table = 'form_instance_value';

    protected $fillable = [
        'form_instance_id','form_field_id','field_value'
    ];

     const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

     /* -----------------------------------------
     Relations
    ------------------------------------------ */

    public function instance()
    {
        return $this->belongsTo(FormInstance::class, 'form_instance_id');
    }

    public function field()
    {
        return $this->belongsTo(FormField::class, 'form_field_id');
    }
}
