<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ComplianceMaster extends Model
{
    protected $table = 'compliance_master';

    protected $fillable = [
        'compliance_code',
        'compliance_month',
        'due_date',
        'state_id',
        'statute_name',
        'form_name',
        'nature_of_compliance_id',
        'submission_authority_id',
        'status',
        'remarks',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

     // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;


    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function nature_compliance_master()
    {
        return $this->belongsTo(NatureComplianceMaster::class, 'nature_of_compliance_id');
    }

    public function submission_authority_master()
    {
        return $this->belongsTo(SubmissionAuthorityMaster::class, 'submission_authority_id');
    }
}
