<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ClientBranchSystemUsermaping extends Model
{
     protected $table = 'client_branch_system_usermaping';

    protected $fillable = [
        'client_id',
        'team_id',
        'branch_id',
        'office_id',
        'role_id',
        'user_id',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by',
    ];

    public $timestamps = true;

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';

     public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id');
    }

    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'role_id');
    }

    public function team()
    {
        return $this->belongsTo(Team::class, 'team_id'); // Add this if you have teams
    }
}
