<?php

namespace App\Mail;

use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WelcomeUserMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user, $token;

    public function __construct(User $user, $token)
    {
        $this->user  = $user;
        $this->token = $token;
    }

    public function build()
    {
        $frontend = rtrim(env('FRONTEND_URL'), '/');

        $url = "{$frontend}/auth/resetpassword?token={$this->token}&email={$this->user->email}";

        return $this->subject('Welcome to VHR Portal')
            ->markdown('emails.welcome_user')
            ->with([
                'name'  => $this->user->first_name,
                'email' => $this->user->email,
                'url'   => $url,
            ]);
    }
}
