<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\UserAuthController;
use App\Http\Controllers\Api\PostController;
use App\Http\Controllers\Api\OfficeController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\ClientController;
use App\Http\Controllers\Api\CommonController;
use App\Http\Controllers\Api\MasterController;
use App\Http\Controllers\Api\TestController;
use App\Http\Controllers\Api\StatutoryController;
use App\Http\Controllers\Api\ComplianceController;
use App\Http\Controllers\Api\FormTemplateController;
use App\Http\Controllers\Api\FormComplianceController;
use App\Http\Controllers\Api\FormInstanceController;
use App\Http\Controllers\Api\FormInstanceGenerationController;
use App\Http\Controllers\Api\TaskController;
use App\Http\Controllers\Api\TaskActivityController;
use App\Http\Controllers\Api\TeamController;


Route::prefix('v1')->group(function () {

    /*
    |--------------------------------------------------------------------------
    | Public API Routes
    |--------------------------------------------------------------------------
    */
    Route::middleware('throttle:5,1')->group(function () {
        Route::post('/register', [UserAuthController::class, 'register'])->name('auth.register');
        Route::post('/login', [UserAuthController::class, 'login'])->name('auth.login');
        Route::post('/forgot-password', [UserAuthController::class, 'forgotPassword'])->name('auth.forgot');
        Route::post('/reset-password', [UserAuthController::class, 'resetPassword'])->name('auth.reset');
        Route::post('/password/setup', [UserAuthController::class, 'setupPassword'])->name('auth.setup-password');
    });

    Route::prefix('master')->group(function () {
        Route::get('cities', [MasterController::class, 'getCities']);
        Route::get('client-departments', [MasterController::class, 'getClientDepartments']);
        Route::get('client-sources', [MasterController::class, 'getClientSources']);
        Route::get('client-classification', [MasterController::class, 'getClientClassification']);
        Route::get('roles', [MasterController::class, 'getRoles']);
        Route::get('states', [MasterController::class, 'getStates']);
        Route::get('cities-by-state/{id}', [MasterController::class, 'getCitiesByStateId']);
        Route::get('nature-compliance', [MasterController::class, 'getNatureCompliance']);
        Route::get('submission-authority', [MasterController::class, 'getSubmissionAuthority']);
    });
    /*
    |--------------------------------------------------------------------------
    | JWT Protected Routes
    |--------------------------------------------------------------------------
    */
    Route::middleware('auth:api')->group(function () {
        Route::post('/logout', [UserAuthController::class, 'logout'])->name('auth.logout');
        Route::post('/refresh-token', [UserAuthController::class, 'refreshToken'])->name('auth.refresh');
        Route::post('/change-password', [UserAuthController::class, 'changePassword'])->name('auth.change-password');
        Route::get('/me', [UserAuthController::class, 'me'])->name('auth.me');

        Route::prefix('office')->group(function () {
            Route::post('/branch', [OfficeController::class, 'createBranchOffice']);
            Route::get('/list', [OfficeController::class, 'listOffices']);
            Route::get('/{id}', [OfficeController::class, 'getOffice']);
            Route::post('/update/{id}', [OfficeController::class, 'updateOffice']);
            Route::delete('/delete/{id}', [OfficeController::class, 'deleteOffice']);
        });

        Route::prefix('users')->group(function () {
            Route::post('/create', [UserController::class, 'createUser']);
            Route::get('/list/{id}', [UserController::class, 'listUsers']);
            Route::get('/org/list', [UserController::class, 'listOrgUsers']);
            Route::get('/{id}', [UserController::class, 'getUser']);
            Route::post('/update/{id}', [UserController::class, 'updateUser']);
            Route::post('/change-password/{id}', [UserController::class, 'changePassword']);
            Route::delete('/delete/{id}', [UserController::class, 'deleteUser']);
        });

        Route::prefix('client')->group(function () {
            Route::post('/create', [ClientController::class, 'createClient']);
            Route::post('/create-branch', [ClientController::class, 'createClientBranch']);
            Route::post('/create-branch-user', [ClientController::class, 'createBranchUser']);
            Route::get('/list', [ClientController::class, 'listClients']);
            Route::get('/list/branch/{id}', [ClientController::class, 'listClientBranch']);
            Route::get('/{id}', [ClientController::class, 'getClient']);
            Route::get('/branch/{id}', [ClientController::class, 'getClientBranch']);
            Route::post('/update/{id}', [ClientController::class, 'updateClient']);
            Route::post('/branch/update/{id}', [ClientController::class, 'updateClientBranch']);
            Route::post('/branch-user/update/{id}', [ClientController::class, 'updateBranchUser']);
            Route::delete('/delete/{id}', [ClientController::class, 'deleteClient']);
            Route::delete('/branch/delete/{id}', [ClientController::class, 'deleteClientBranch']);
        });

        Route::prefix('statutory')->group(function () {
            Route::post('/create', [StatutoryController::class, 'createStatutory']);
            Route::post('/update/{id}', [StatutoryController::class, 'updateStatutory']);
            Route::get('/get/{id}', [StatutoryController::class, 'getStatutory']);
            Route::get('/list', [StatutoryController::class, 'listStatutory']);
            Route::delete('/delete/{id}', [StatutoryController::class, 'deleteStatutory']);

            Route::post('/sections/create', [StatutoryController::class, 'createStatutorySection']);
            Route::get('/sections/list', [StatutoryController::class, 'listStatutorySections']);
            Route::get('/sections/get/{id}', [StatutoryController::class, 'getStatutorySection']);
            Route::post('/sections/update/{id}', [StatutoryController::class, 'updateStatutorySection']);
            Route::post('/sections/updatestatus/{id}', [StatutoryController::class, 'updateStatutorySectionStatus']);
            Route::delete('/sections/delete/{id}', [StatutoryController::class, 'deleteStatutorySection']);
        });

        Route::prefix('compliance')->group(function () {
            Route::get('/list', [ComplianceController::class, 'listCompliance']);
            Route::get('/{id}', [ComplianceController::class, 'getCompliance']);
            Route::post('/create', [ComplianceController::class, 'createCompliance']);
            Route::post('/update/{id}', [ComplianceController::class, 'updateCompliance']);
            Route::delete('/delete/{id}', [ComplianceController::class, 'deleteCompliance']);

            Route::post('/create/keyAreaCompliance', [ComplianceController::class, 'createKeyAreaCompliance']);
            Route::post('/update/keyAreaCompliance/{id}', [ComplianceController::class, 'updateKeyAreaCompliance']);
            Route::get('/list/keyAreaCompliance', [ComplianceController::class, 'listKeyAreaCompliance']);
            Route::delete('/delete/keyAreaCompliance/{id}', [ComplianceController::class, 'deleteKeyAreaCompliance']);
            Route::post('/statusUpdate/keyAreaCompliance/{id}', [ComplianceController::class, 'updateKeyAreaComplianceStatus']);

            Route::post('/create/keyAreaSubCompliance', [ComplianceController::class, 'createKeyAreaSubCompliance']);
            Route::post('/update/keyAreaSubCompliance/{id}', [ComplianceController::class, 'updateKeyAreaSubCompliance']);
            Route::post('/statusUpdate/keyAreaSubCompliance/{id}', [ComplianceController::class, 'updateKeyAreaSubComplianceStatus']);
            Route::delete('/delete/keyAreaSubCompliance/{id}', [ComplianceController::class, 'deleteKeyAreaSubCompliance']);
            Route::get('/list/keyAreaSubCompliance/{keyAreaComplianceId}', [ComplianceController::class, 'listKeyAreaSubCompliance']);
        });

            Route::prefix('tasks')->group(function () {
            Route::get('/', [TaskController::class, 'index']);
            Route::post('/', [TaskController::class, 'store']);
            Route::get('/statistics/{id}', [TaskController::class, 'statistics']);

            Route::get('/{id}', [TaskController::class, 'show']);
            Route::put('/{id}', [TaskController::class, 'update']);
            Route::delete('/{id}', [TaskController::class, 'destroy']);

            // Activities
            Route::post('/{id}/activity', [TaskActivityController::class, 'store']);
            Route::get('/{id}/activities', [TaskActivityController::class, 'index']);
            Route::get('/activities/{activityId}/download', [TaskActivityController::class, 'downloadAttachment']);
        });


        Route::prefix('common')->group(function () {
            Route::post('/updateRecord', [CommonController::class, 'updateRecord']);
        });

        Route::get('/forms/{id}/definition', [FormTemplateController::class, 'definition']);

        Route::get(
            '/clients/{clientId}/branches/{branchId}/forms',
            [FormComplianceController::class, 'applicableForms']
        );

        // Form Templates
        Route::get('/form-templates', [FormTemplateController::class, 'list']);
        Route::post('/form-templates', [FormTemplateController::class, 'create']);
        Route::get('/form-templates/{id}', [FormTemplateController::class, 'get']);
        Route::post('/form-templates/update/{id}', [FormTemplateController::class, 'upateForm']);
        Route::delete('/form-templates/delete/{id}', [FormTemplateController::class, 'deleteForm']);
        Route::post('/form-templates/clone/{id}', [FormTemplateController::class, 'cloneForm']);

        // Form Instances
        Route::post('/form-instances', [FormInstanceController::class, 'create']);
        Route::get('/form-instances/list', [FormInstanceController::class, 'list']);
        Route::get('/form-instances/{id}', [FormInstanceController::class, 'get']);
        Route::post('/form-instances/{id}/save', [FormInstanceController::class, 'save']);
        Route::post('/form-instances/{id}/action', [FormInstanceController::class, 'action']);
        Route::post('/form-instances/{id}/upload', [FormInstanceController::class, 'upload']);
        Route::post('/form-instances/generate', [FormInstanceGenerationController::class, 'generate']);
        Route::delete('/form-instances/{id}/deleteAttachment', [FormInstanceController::class, 'deleteAttachment']);
        Route::get('/form-instances/{id}/preview',[FormInstanceController::class, 'preview']);
        Route::get('/form-instances/{id}/download', [FormInstanceController::class, 'download']);
    });

     // Teams endpoints
    Route::get('teams/list', [TeamController::class, 'listTeams']);
    Route::post('teams/create', [TeamController::class, 'createTeam']);
    Route::get('teams/{id}', [TeamController::class, 'getTeam']);
    Route::put('teams/update/{id}', [TeamController::class, 'updateTeam']);
    Route::delete('teams/delete/{id}', [TeamController::class, 'deleteTeam']);
    Route::get('teams/{id}/members', [TeamController::class, 'getTeamMembers']);
    Route::get('teams/{id}/available-users', [TeamController::class, 'getAvailableUsers']);
    Route::post('teams/{id}/members', [TeamController::class, 'addUserToTeam']);
    Route::delete('teams/{id}/members/{memberId}', [TeamController::class, 'removeUserFromTeam']);
    Route::put('teams/{id}/members/{memberId}/toggle-status', [TeamController::class, 'toggleUserStatus']);
    Route::get('teams/search', [TeamController::class, 'searchTeams']);

    Route::prefix('test')->group(function () {
        Route::get('sendemail', [TestController::class, 'testEmail']);
        Route::post('generateDueDates', [TestController::class, 'generateDueDates']);
    });
    Route::get('/form-instance/value/{id}/file', [FormInstanceController::class, 'viewFile']);
});
