<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;
use App\Models\UserAuth;
use App\Models\RoleMaster;
use App\Models\Office;

class User extends Authenticatable implements JWTSubject
{
    use HasFactory;

    protected $table = 'users';

    protected $fillable = [
        'user_auth_id',
        'user_code',
        'first_name',
        'last_name',
        'email',
        'phone',
        'contact',
        'address',
        'city_id',
        'state_id',
        'pincode',
        'photo',
        'user_type',
        'office_id',
        'client_id',
        'client_branch_id',
        'role_id',
        'joining_date',
        'relived_on',
        'emergency_contact_name',
        'emergency_contact_phone',
        'emergency_contact_mobile',
        'emergency_contact_address',
        'headers',
        'register_ip',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

    /**
     * Use custom timestamps: created_on, updated_on
     */
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    /**
     * Hide internal timestamp fields
     */
    protected $hidden = [
        'created_on',
        'updated_on'
    ];

    /**
     * JWT Methods
     */
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    /**
     * Relationships
     */
    public function auth()
    {
        return $this->belongsTo(UserAuth::class, 'user_auth_id');
    }

    public function role()
    {
        return $this->belongsTo(RoleMaster::class, 'role_id');
    }

    public function office()
    {
        return $this->belongsTo(Office::class, 'office_id');
    }

    public function clientBranch()
    {
        return $this->belongsTo(ClientBranch::class, 'client_branch_id');
    }

     public function city_master()
    {
        return $this->belongsTo(CityMaster::class, 'city_id');
    }

    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }
}
