<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    protected $table = 'team';

    protected $fillable = [
        'team_name', 'is_active', 'is_deleted'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';

    public $timestamps = true;

    protected $casts = [
        'is_active' => 'boolean',
        'is_deleted' => 'boolean',
        'created_on' => 'datetime',
        'updated_on' => 'datetime',
    ];

    /**
     * Get all team members
     */
    public function team_members()
    {
        return $this->hasMany(TeamUsersMapping::class, 'team_id');
    }
}
