<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TaskActivity extends Model
{
    protected $table = 'task_activities';

    protected $fillable = [
        'task_id',
        'user_id',
        'type',
        'message',
        'attachment_path',
        'attachment_name',
    ];

    // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    /**
     * Get the user who created the activity
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the task for the activity
     */
    public function task(): BelongsTo
    {
        return $this->belongsTo(Task::class);
    }
}
