<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormField extends Model
{
    protected $table = 'form_field';

    protected $fillable = [
        'form_template_id','field_key','field_label',
        'field_type','is_required','is_workflow_param',
        'is_visible_to_client','display_order'
    ];

    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    /* -----------------------------------------
     Relations
    ------------------------------------------ */

    public function template()
    {
        return $this->belongsTo(FormTemplate::class, 'form_template_id');
    }

    public function instanceValues()
    {
        return $this->hasMany(FormInstanceValue::class, 'form_field_id');
    }
}
