<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\ClientBranch;
use App\Models\CityMaster;
use App\Models\StateMaster;

class ClientMaster extends Model
{
    protected $table = 'client_master';

    protected $fillable = [
        'client_code',
        'department_id',
        'source_id',
        'classification_id',
        'client_name',
        'client_bussiness_name',
        'address',
        'state_id',
        'city_id',
        'pincode',
        'cost',
        'email',
        'effective_month',
        'logo',
        'is_active',
        'is_deleted',
        'created_by',
        'updated_by'
    ];

     // Use custom timestamp fields
    const CREATED_AT = 'created_on';
    const UPDATED_AT = 'updated_on';
    public $timestamps = true;

    public function branches()
    {
        return $this->hasMany(ClientBranch::class, 'client_id', 'id');
    }

    public function city_master()
    {
        return $this->belongsTo(CityMaster::class, 'city_id');
    }

    public function state_master()
    {
        return $this->belongsTo(StateMaster::class, 'state_id');
    }

    public function department()
    {
        return $this->belongsTo(ClientDepartmentMaster::class, 'department_id', 'id');
    }

    public function source()
    {
        return $this->belongsTo(ClientSourceMaster::class, 'source_id', 'id');
    }

    public function classification()
    {
        return $this->belongsTo(ClientClassificationMaster::class, 'classification_id', 'id');
    }

}
