<?php

namespace App\Http;

use Illuminate\Foundation\Http\Kernel as HttpKernel;

class Kernel extends HttpKernel
{
    /**
     * Global HTTP middleware stack — applied to every request.
     */
    protected $middleware = [
        \App\Http\Middleware\TrustProxies::class,
        \Illuminate\Foundation\Http\Middleware\HandlePrecognitiveRequests::class,
        \Illuminate\Foundation\Http\Middleware\PreventRequestsDuringMaintenance::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \App\Http\Middleware\HandleCors::class,
    ];

    /**
     * Route middleware groups.
     */
    protected $middlewareGroups = [

        // -----------------------------------------------------------
        // ✔ API-only middleware stack — NO sessions, NO cookies
        // -----------------------------------------------------------
        'api' => [
            'throttle:api',
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],
    ];

    /**
     * Route middleware — used for specific routes.
     */
    protected $routeMiddleware = [

        // ✔ JWT authentication middleware
        'auth'      => \App\Http\Middleware\Authenticate::class,
        'auth:api'  => \PHPOpenSourceSaver\JWTAuth\Http\Middleware\Authenticate::class,

        // ✔ Authorization / roles
        'role'      => \App\Http\Middleware\RoleMiddleware::class,
        'can'       => \Illuminate\Auth\Middleware\Authorize::class,

        // ✔ Route throttling
        'throttle'  => \Illuminate\Routing\Middleware\ThrottleRequests::class,

        // ✔ Route model bindings
        'bindings'  => \Illuminate\Routing\Middleware\SubstituteBindings::class,

        // Signed routes
        'signed'    => \App\Http\Middleware\ValidateSignature::class,
    ];
}
