<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Services\FormInstanceGeneratorService;
use Illuminate\Http\JsonResponse;
use Throwable;

class FormInstanceGenerationController extends Controller
{
    protected FormInstanceGeneratorService $service;

    public function __construct(FormInstanceGeneratorService $service)
    {
        $this->service = $service;
    }

    /**
     * Manually trigger form instance generation
     * Same logic as monthly cron
     */
    public function generate(): JsonResponse
    {
        try {
            $result = $this->service->generate();

            return response()->json([
                'success' => true,
                'message' => 'Form instances generated successfully',
                'data' => $result,
            ]);
        } catch (Throwable $e) {

            report($e);

            return response()->json([
                'success' => false,
                'message' => 'Form instance generation failed',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
